module.exports = (sequelize, DataTypes) => {
  const Strength = sequelize.define(
    'Strength',
    {
      id: {
        allowNull: false,
        autoIncrement: true,
        primaryKey: true,
        type: DataTypes.INTEGER,
      },
      name: {
        allowNull: false,
        type: DataTypes.STRING,
        field: 'name',
      },
      info: {
        type: DataTypes.STRING(512),
        field: 'info',
      },
      cardinalPowerId: {
        allowNull: false,
        type: DataTypes.INTEGER,
        references: {
          model: 'cardinal_powers',
          key: 'id',
        },
        field: 'cardinal_power_id',
      },
      icon: {
        allowNull: true,
        type: DataTypes.STRING,
        field: 'icon',
      },
    },
    {
      paranoid: false,
      timestamps: false,
      tableName: 'strengths',
    },
  );
  Strength.associate = models => {
    Strength.belongsTo(models.CardinalPower, {
      foreignKey: 'cardinalPowerId',
      as: 'cardinalPower',
    });
    Strength.hasMany(models.Behavior, {
      foreignKey: 'strengthId',
      as: 'behaviors',
    });
    Strength.belongsToMany(models.Challenge, {
      through: 'ChallengeStrength',
      foreignKey: 'strengthId',
      as: 'challenge',
      timestamps: false,
    });

    Strength.belongsToMany(models.User, {
      through: 'UserStrength',
      foreignKey: 'strengthId',
      as: 'user',
      timestamps: false,
    });

    Strength.hasMany(models.RouteStrength, {
      foreignKey: 'strengthId',
      as: 'routeStrengths',
    });
  };
  return Strength;
};
