module.exports = (sequelize, DataTypes) => {
  const UserActionPlan = sequelize.define(
    'UserActionPlan',
    {
      id: {
        allowNull: false,
        autoIncrement: true,
        primaryKey: true,
        type: DataTypes.INTEGER,
      },
      userAspectReinventationId: {
        allowNull: false,
        type: DataTypes.INTEGER,
        references: {
          model: 'user_aspects_reinventation',
          key: 'id',
        },
        field: 'user_aspect_reinventation_id',
      },
      actionPlanId: {
        allowNull: false,
        type: DataTypes.INTEGER,
        references: {
          model: 'actions_plan',
          key: 'id',
        },
        field: 'action_plan_id',
      },
      active: {
        type: DataTypes.INTEGER,
        field: 'active',
      },
      createdAt: {
        allowNull: false,
        type: DataTypes.DATE,
        field: 'created_at',
      },
      updatedAt: {
        allowNull: false,
        type: DataTypes.DATE,
        field: 'updated_at',
      },
      deletedAt: {
        type: DataTypes.DATE,
        field: 'deleted_at',
      },
      startDate: {
        type: DataTypes.DATE,
        field: 'start_date',
      },
      endDate: {
        type: DataTypes.DATE,
        field: 'end_date',
      },
    },
    {
      paranoid: true,
      timestamps: true,
      tableName: 'user_actions_plan',
    },
  );
  UserActionPlan.associate = models => {
    UserActionPlan.belongsTo(models.UserAspectReinventation, {
      foreignKey: 'userAspectReinventationId',
    });
    UserActionPlan.belongsTo(models.ActionPlan, {
      foreignKey: 'actionPlanId',
    });
    UserActionPlan.belongsTo(models.ActionPlan, {
      foreignKey: 'actionPlanId',
      as: 'actionPlan',
    });
  };
  return UserActionPlan;
};
