module.exports = (sequelize, DataTypes) => {
  const UserHabit = sequelize.define(
    'UserHabit',
    {
      id: {
        allowNull: false,
        autoIncrement: true,
        primaryKey: true,
        type: DataTypes.INTEGER,
      },
      userAspectReinventationId: {
        allowNull: false,
        type: DataTypes.INTEGER,
        references: {
          model: 'user_aspects_reinventation',
          key: 'id',
        },
        field: 'user_aspect_reinventation_id',
      },
      habitId: {
        allowNull: false,
        type: DataTypes.INTEGER,
        references: {
          model: 'habits',
          key: 'id',
        },
        field: 'habit_id',
      },
      active: {
        type: DataTypes.INTEGER,
        field: 'active',
      },
      completedDate: {
        type: DataTypes.DATE,
        field: 'completed_date',
      },
      days: {
        type: DataTypes.TEXT,
        defaultValue: '[]',
        get() {
          const value = this.getDataValue('days') || '[]';
          return JSON.parse(value);
        },
        set(value) {
          return this.setDataValue('days', JSON.stringify(value));
        },
        field: 'days',
      },
      hour: {
        type: DataTypes.STRING(45),
        field: 'hour',
      },
      createdAt: {
        allowNull: false,
        type: DataTypes.DATE,
        field: 'created_at',
      },
      updatedAt: {
        allowNull: false,
        type: DataTypes.DATE,
        field: 'updated_at',
      },
      deletedAt: {
        type: DataTypes.DATE,
        field: 'deleted_at',
      },
    },
    {
      paranoid: true,
      timestamps: true,
      tableName: 'user_habits',
    },
  );
  UserHabit.associate = models => {
    UserHabit.belongsTo(models.UserAspectReinventation, {
      foreignKey: 'userAspectReinventationId',
      as: 'userAspectReinventation',
    });
    UserHabit.belongsTo(models.Habit, {
      foreignKey: 'habitId',
      as: 'habit',
    });
  };
  return UserHabit;
};
