module.exports = (sequelize, DataTypes) => {
  const UserNotification = sequelize.define(
    'UserNotification',
    {
      id: {
        allowNull: false,
        autoIncrement: true,
        primaryKey: true,
        type: DataTypes.INTEGER,
      },
      userId: {
        allowNull: false,
        type: DataTypes.INTEGER,
        references: {
          model: 'users',
          key: 'id',
        },
        field: 'user_id',
      },
      actionPlanId: {
        allowNull: true,
        type: DataTypes.INTEGER,
        references: {
          model: 'actions_plan',
          key: 'id',
        },
        field: 'action_plan_id',
      },
      habitId: {
        allowNull: true,
        type: DataTypes.INTEGER,
        references: {
          model: 'habits',
          key: 'id',
        },
        field: 'habit_id',
      },
      date: {
        allowNull: false,
        type: DataTypes.DATE,
        field: 'date',
      },
      title: {
        allowNull: false,
        type: DataTypes.STRING,
        field: 'title',
      },
      body: {
        allowNull: true,
        type: DataTypes.STRING,
        field: 'body',
      },
      sent: {
        allowNull: true,
        type: DataTypes.DATE,
        field: 'sent',
      },
      createdAt: {
        allowNull: false,
        type: DataTypes.DATE,
        field: 'created_at',
      },
      updatedAt: {
        allowNull: false,
        type: DataTypes.DATE,
        field: 'updated_at',
      },
    },
    {
      paranoid: false,
      timestamps: true,
      tableName: 'user_notifications',
    },
  );
  UserNotification.associate = models => {
    UserNotification.belongsTo(models.User, {
      foreignKey: 'userId',
      as: 'user',
    });
    UserNotification.belongsTo(models.User, {
      foreignKey: 'actionPlanId',
      as: 'actionPlan',
    });
    UserNotification.belongsTo(models.User, {
      foreignKey: 'habitId',
      as: 'habit',
    });
  };
  return UserNotification;
};
