module.exports = (sequelize, DataTypes) => {
  const UserPowerfulQuestion = sequelize.define(
    'UserPowerfulQuestion',
    {
      id: {
        allowNull: false,
        autoIncrement: true,
        primaryKey: true,
        type: DataTypes.INTEGER,
      },
      userAspectReinventationId: {
        allowNull: false,
        type: DataTypes.INTEGER,
        references: {
          model: 'user_aspects_reinventation',
          key: 'id',
        },
        field: 'user_aspect_reinventation_id',
      },
      powerfulQuestionId: {
        allowNull: false,
        type: DataTypes.INTEGER,
        references: {
          model: 'powerful_questions',
          key: 'id',
        },
        field: 'powerful_question_id',
      },
      createdAt: {
        allowNull: false,
        type: DataTypes.DATE,
        field: 'created_at',
      },
      updatedAt: {
        allowNull: false,
        type: DataTypes.DATE,
        field: 'updated_at',
      },
      deletedAt: {
        type: DataTypes.DATE,
        field: 'deleted_at',
      },
      value: {
        type: DataTypes.INTEGER,
        field: 'value',
      },
    },
    {
      paranoid: true,
      timestamps: true,
      tableName: 'user_powerful_questions',
    },
  );
  UserPowerfulQuestion.associate = models => {
    UserPowerfulQuestion.belongsTo(models.PowerfulQuestion, {
      foreignKey: 'powerfulQuestionId',
    });
    UserPowerfulQuestion.belongsTo(models.UserAspectReinventation, {
      foreignKey: 'userAspectReinventationId',
    });
  };
  return UserPowerfulQuestion;
};
