const AWS = require('aws-sdk');
const fs = require('fs');
const _ = require('lodash');
const config = require('./config');

module.exports.config = async serverless => {
  const { stage = 'dev' } = _.get(serverless, 'pluginManager.cliOptions') || _.get(serverless, 'options');

  // If is running local first go to find the local config
  if (!stage || stage === 'dev') {
    const envLocalFile = './env/dev.json';

    if (fs.existsSync(envLocalFile)) {
      const content = fs.readFileSync(envLocalFile);
      const response = JSON.parse(content);
      return response;
    }
  }

  const bucketName = config.get('aws.bucket');
  const pathConfig = `env/${stage}.json`;
  try {
    const client = new AWS.S3({
      accessKeyId: config.get('aws.accessKey'),
      secretAccessKey: config.get('aws.secretAccessKey'),
      region: config.get('aws.region'),
    });
    const content = await client.getObject({ Bucket: bucketName, Key: pathConfig }).promise();
    const response = JSON.parse(content.Body.toString());
    return response;
  } catch (e) {
    const message = `S3 key: ${pathConfig} - ${e.message}`;
    throw message;
  }
};
