const express = require('express');
const User = require('../controllers/user');

const router = express.Router();

router.post('/external/', User.create);
router.get('/external/register-initial-data', User.getRegisterInitialData);
router.post('/external/login', User.login);
router.post('/external/confirm-email', User.confirmEmail);
router.post('/external/send-confirmation-email-code', User.sendConfirmationEmailCode);
router.post('/external/send-reset-password-code', User.sendResetPasswordCode);
router.post('/external/validate-reset-password-code', User.validateResetPasswordCode);
router.put('/', User.update);
router.put('/update-password', User.updatePassword);
router.post('/send-confirmation-email-code', User.sendConfirmationEmailCode);
router.get('/detail', User.detail);
router.post('/add-device-token', User.addDeviceToken);
router.post('/remove-device-token', User.removeDeviceToken);

module.exports = router;
