const db = require('../database/models');

const {
  Questionnarie, Behavior, BehaviorPoint, SuscriptionType, CardinalPower,
} = db;

exports.getAnswers = async (userId, suscriptionTypeId) => {
  try {
    const currentQuestionnarieId = await Questionnarie.findOne({
      attributes: ['id'],
      where: { userId, suscriptionTypeId },
    });

    if (!currentQuestionnarieId) {
      const error = {
        name: 'CUESTIONARIO_INEXISTENTE',
      };
      throw error;
    }

    const { id: questionnarieId = '' } = currentQuestionnarieId;

    const currentQuestionnarie = await Questionnarie.findOne({
      where: { userId, suscriptionTypeId },
      include: [
        { model: SuscriptionType, as: 'suscriptionType' },
        {
          model: CardinalPower,
          as: 'cardinalPower',
          attributes: ['id', 'name'],
        },
        {
          model: Behavior,
          as: 'behavior',
          through: {
            attributes: [],
          },
          include: [
            {
              model: BehaviorPoint,
              as: 'behaviorPoint',
              through: {
                attributes: [],
                where: { questionnarieId },
              },
            },
          ],
        },
      ],
    });

    const { cardinalPower = {}, behavior = [] } = currentQuestionnarie;
    const behaviors = [];
    behavior.forEach(x => {
      const { id = '', name = '', behaviorPoint = [] } = x;
      behaviors.push({ id, name, value: behaviorPoint.length ? behaviorPoint[0].id : 0 });
    });

    return { suscriptionTypeId, cardinalPower, behaviors };
  } catch (e) {
    throw e;
  }
};
