const moment = require('moment');
const db = require('../database/models');
const utils = require('../utils/utils');
const serviceUtils = require('./utils.js');

const {
  UserRoute, Route, User,
} = db;

/**
 * Update user current route
 */
exports.setRoute = async (userId, routeId) => {
  try {

    const existRoute = await Route.findOne({ where: { id: routeId } });

    if (!existRoute) {
      const error = {
        name: 'NO_ENCONTRADO',
      };
      throw error;
    }

    await UserRoute.update({ disabledDate: moment().utc() }, { where: { userId } });

    await utils.updateOrCreate(
      UserRoute,
      { userId, routeId },
      {
        userId,
        routeId,
        enabledDate: moment().utc(),
        disabledDate: null,
      },
    );

    const currentRoute = await Route.findOne({
      attributes: ['id', 'name', 'info'],
      where: {
        id: routeId,
      },
    });

    const { id: challengeId = '' } = await serviceUtils.getCurrentUserChallenge(userId, routeId) || {};

    return { currentRoute, currentChallengeId: challengeId };
  } catch (e) {
    throw e;
  }
};

/**
 * Get user routes
 */
exports.getRoutes = async userId => {
  try {
    let routes = await Route.findAll({
      attributes: ['id', 'name', 'longName'],
      include: [{
        model: User,
        as: 'user',
        where: { id: userId },
        required: false,
      }],
    });

    routes = JSON.parse(JSON.stringify(routes));
    routes.forEach(r => {
      let { user = [] } = r;

      if (user.length) {
        user = user.length ? user[0] : {};
        const { UserRoute = [] } = user;
        r.current = UserRoute.disabledDate ? 0 : 1;
      } else {
        r.current = 0;
      }
      delete r.user;
    });

    return { routes };
  } catch (e) {
    throw e;
  }
};
